/**************************************
"A Duckpin Tournament" problem and code
submitted by Roger Aude for the ACM Pacific
NW Programming Contest on 15 November 1997.
**************************************/
#include<stdio.h>
#include<ctype.h>
#define INPUT "Duckpins.dat"
FILE *ifp;
char ch;

int		NmbrPlyrs;       		//number of players
char	Players[5][11];    	//names of the players
int	Ball[4][13];			//ball scores on each try
int	Frame[11];				//frame by frame score
int   Score[5];				//series score for the players
int	HiGame, HiPlayer;    //high game score & player


int main(void)
{

	if ((ifp = fopen(INPUT, "r")) == NULL)
   {
      printf("Cannot open input file.\n");
      return 1;
   }

   fscanf(ifp,"%d",&NmbrPlyrs);
   while (NmbrPlyrs != 0)
   {
   	int Player=1, HiScore=0, HiPlayer=0, HiSeries =0, Winner=0;
      int series[5];

      for (int a=0;a<5;a++)
      	series[a]=0;
      //get player names
      while (Player<=NmbrPlyrs)
      {
         int i=1;
      	while (isspace(ch=fgetc(ifp)));
         Players[Player][0]=ch;
         while (isalpha(ch=fgetc(ifp)) && i<10)
         {
         	Players[Player][i]=ch;
            i++;
         }
         Players[Player][i]='\0';
         Player++;
      }

      //get ball by ball score per player per game
      for (int game=1;game<4;game++)
      	for (Player=1;Player<=NmbrPlyrs;Player++)
      	{
            for(int x=0;x<4;x++)
            	for(int y=0;y<13;y++)
               	Ball[x][y]=0;

	      	//get a player's score for a game
				for (int ball=1;ball<4;ball++)
         	{
            	int k=1;
      			while ((ch=fgetc(ifp))!='\n')
   				{
                  switch (ch)
                  {
                  	case '1':
                     {
                     	if ((ch=fgetc(ifp))=='0')
                        {
                        	Ball[ball][k]=10;
                           k++;
                        }
                        else
								{
                           ungetc(ch,ifp);
                           Ball[ball][k]=1;
                           k++;
                        }
								break;
                     }
                     case '2':
							{
                       	Ball[ball][k]=2;
                        k++;
                        break;
                     }
                     case '3':
							{
                       	Ball[ball][k]=3;
                        k++;
                        break;
                     }
                     case '4':
							{
                       	Ball[ball][k]=4;
                        k++;
                        break;
                     }
                     case '5':
							{
                       	Ball[ball][k]=5;
                        k++;
                        break;
                     }
                     case '6':
							{
                       	Ball[ball][k]=6;
                        k++;
                        break;
                     }
                     case '7':
							{
                       	Ball[ball][k]=7;
                        k++;
                        break;
                     }
                     case '8':
							{
                       	Ball[ball][k]=8;
                        k++;
                        break;
                     }
                     case '9':
							{
                       	Ball[ball][k]=9;
                        k++;
                        break;
                     }
                     case '0':
							{
                       	Ball[ball][k]=0;
                        k++;
                        break;
                     }
                     case '-':
                     {
                     	if ((ch=fgetc(ifp))=='1')
                        	if ((ch=fgetc(ifp))!='0')
                        		ungetc(ch,ifp);
                        Ball[ball][k]=-20;
                        k++;
                     	break;
                     }
                     default : break;
                  }
               }
         	}
				//adjust tries to correct frame
            for (int frame=1;frame<13;frame++)
            {
					if ((Ball[1][frame]==10)||(Ball[1][frame]<0))
            	{	//adjust 2nd try to correct frame
						for (int j=12;j>frame;j--)
                  	Ball[2][j] = Ball[2][j-1];
                  Ball[2][frame]=0;
               }
            }
            for (int frame=1;frame<13;frame++)
            {
					if (((Ball[1][frame]+Ball[2][frame])==10)||
                   (Ball[1][frame]<0)||
                   (Ball[2][frame]<0))
            	{	//adjust 3nd try to correct frame
						for (int j=12;j>frame;j--)
                  	Ball[3][j] = Ball[3][j-1];
                  Ball[3][frame]=0;
               }
            }
            //compute score
            Frame[0]=0;
            for (int frame=1;frame<=10;frame++)
            {
            	if (Ball[1][frame]==10)	//strike get next two tries
               {
               	if (frame<10)
                  {
               		if (Ball[1][frame+1]==10) 	//next frame is strike
                  	{                         	//get 1st try in frame following
                  		if (Ball[1][frame+2]>=0)
                     		Frame[frame]=Frame[frame-1]+20+Ball[1][frame+2];
                     	else
                     		Frame[frame]=Frame[frame-1]+20;
                  	}
                  	else
                  		if (Ball[1][frame+1]<0) //foul 1st try of next frame
                     		Frame[frame]=Frame[frame-1]+10;
                     	else
                     		if (Ball[2][frame+1]<0) //foul 2nd try of next frame
                        		Frame[frame]=Frame[frame-1]+10+Ball[1][frame+1];
                        	else
                           	Frame[frame]=Frame[frame-1]+10+Ball[1][frame+1]+
                           						Ball[2][frame+1];
                  }
                  else	//last frame
                  {
                  	if (Ball[1][frame+1]<0)
                     	Frame[frame]=Frame[frame-1]+10;
                     else
                     	if (Ball[1][frame+2]<0)
                        	Frame[frame]=Frame[frame-1]+10+Ball[1][frame+1];
                        else
                           Frame[frame]=Frame[frame-1]+10+Ball[1][frame+1]+
                  								Ball[1][frame+2];
                  }
               }
               else							//if spare get 1st try next frame
	               if (Ball[1][frame]+Ball[2][frame]==10)
                  	if (Ball[1][frame+1]<0) //foul 1st try of next frame
                     	Frame[frame]=Frame[frame-1]+10;
                     else
                     	Frame[frame]=Frame[frame-1]+10+Ball[1][frame+1];
                  else                //no strike or spare
                  	if (Ball[1][frame]<0)
                     	Frame[frame]=Frame[frame-1];
                     else
                     	if (Ball[2][frame]<0)
                     		Frame[frame]=Frame[frame-1]+Ball[1][frame];
                        else
                        	if (Ball[3][frame]<0)
                           	Frame[frame]=Frame[frame-1]+Ball[1][frame]+
                              					Ball[2][frame];
                           else
                           	Frame[frame]=Frame[frame-1]+Ball[1][frame]+
                              					Ball[2][frame]+Ball[3][frame];
            }
            if (Frame[10]>HiScore)
            {
            	HiPlayer = Player;
               HiScore = Frame[10];
            }
            series[Player]=series[Player]+Frame[10];
	      	//print the score
				printf("%-10s", Players[Player]);
            for (int s=1;s<=10;s++)
            	printf("%4d",Frame[s]);
            printf("\n");
      	}
      for (int b=1;b<=NmbrPlyrs;b++)
      	if (series[b]>HiSeries)
         {
         	Winner=b;
            HiSeries=series[b];
         }
      printf("%s has the high series score of %d.\n",Players[Winner],HiSeries);
      printf("%s has the high game score of %d.\n",Players[HiPlayer],HiScore);
      printf("\n");
      while (ch=fgetc(ifp)!='#');

      //get the number of the next set of players
      fscanf(ifp,"%d",&NmbrPlyrs);
   }

//   printf("Press enter to terminate.\n");
//   getchar();
   return 0;
}